# OP 2021 - Problem 4. Lost Lumens

# Copyright 2021, Robert W. Hasker

import math

def sqr(x):
  return x * x

def distance_to_corner(center_distance, height, width):
  up = height / 2.0
  over = width / 2.0
  center_to_corner = math.sqrt(sqr(up) + sqr(over))
  #print("Distance to corner from center: " + str(center_to_corner))
  return math.sqrt(sqr(center_distance) + sqr(center_to_corner))

distance = float(input("Distance to center: "))
height = float(input("Height of screen: "))
width = float(input("Width of screen: "))
corner_distance = distance_to_corner(distance, height, width)
#print(f'corner distance: {corner_distance:.2f}')

falloff = 0.9
brightness_at_center = 1 / sqr(distance) * falloff * 1 / sqr(distance)
brightness_at_corner = 1 / sqr(corner_distance) * falloff * 1 / sqr(corner_distance)

#print(f'Brightness at center: {brightness_at_center:.8f}, brightness at corner: {brightness_at_corner:.8f}')
percent_loss = 100 * (brightness_at_center - brightness_at_corner) / brightness_at_center
print(f'Loss at corner: {percent_loss:.4f}%')

