# OP 2022 - Problem 3. Magic Number

# This represents a possible solution - not the only or best solution
# Copyright 2022, Robert W. Hasker

from sys import stdin

def get_win_loss():
  line = stdin.readline().split()
  if not line:
    return (0, 0)
  return (int(line[0]), int(line[1]))

GAMES = 162

record = []

(w, l) = get_win_loss()
while w > 0 or l > 0:
  record.append((w, l))
  (w, l) = get_win_loss()

lead_wins = record[0][0]
for (w, l) in record[1:]:
  # print("Wins: " + str(w) + ", losses: " + str(l))
  m = GAMES - lead_wins - l + 1
  if m > 0:
    print(m)
  else:
    print("eliminated from playoff contention")
