# OP 2022 - Problem 4. Crossing Bridges

# This represents a possible solution - not the only or best solution
# Copyright 2022, Robert W. Hasker

from sys import stdin

def read_bridge_schematics():
  result = []
  current_schematic = []
  for line in stdin:
    line = line.rstrip()
    #print("line: `" + line + "'")
    if line == "+":
      result.append(current_schematic)
      current_schematic = []
    else:
      current_schematic.append(line)
  result.append(current_schematic)
  return result

def fall(level, section, numlevels, schematic):
  while level < numlevels and schematic[level][section] == ' ':
    level += 1
  if level >= numlevels:
    return -1
  else:
    return level

def try_to_cross_bridge(schematic):
  name = schematic[0]
  print(name)
  schematic = schematic[1:]
  roomwidth = len(max(schematic, key=len))
  numlevels = len(schematic)
  for i in range(numlevels):
    schematic[i] = schematic[i] + " " * (roomwidth - len(schematic[i]))
  section = 0
  height = fall(0, section, numlevels, schematic)
  while section < roomwidth - 1:
    if height < 0:
      print("NOT CROSSABLE")
      return
    section += 1
    top = fall(0, section, numlevels, schematic)
    if top == height - 1 or top < 0:
      # step up or fall to center of planet
      height = top
    elif top < height:
      # tried to step up too high
      height = -1
    else: # top > height
      height = top
  print("OK")

all_schematics = read_bridge_schematics()
for s in all_schematics:
  try_to_cross_bridge(s)
