# OP 2022 - Problem 5. Sally Sells Seashells

# This represents a possible solution - not the only or best solution
# Copyright 2022, Robert W. Hasker

from sys import stdin

lines = stdin.read()
weights = lines.split()
weights = [int(n) for n in weights]
weights = sorted(weights, reverse=True)

MAXBUCKETS = 100
MAX_BUCKET_WEIGHT = 100

buckets = [0 for i in range(MAXBUCKETS)]
for shell in weights:
  b = 0
  while b < MAXBUCKETS and buckets[b] + shell > MAX_BUCKET_WEIGHT:
    b += 1
  buckets[b] += shell

for b in range(MAXBUCKETS):
  if buckets[b] == 0:
    print(b)
    exit()

    
