# OP 2022 - Problem 6. Worst Words

# This represents a possible solution - not the only or best solution
# Copyright 2022, Robert W. Hasker

from sys import stdin

def three_common_letters(target, words, pos1, pos2, pos3):
  matches = []
  for w in words:
    if w[pos1] == target[pos1] and w[pos2] == target[pos2] and w[pos3] == target[pos3]:
        # includes target assuming that's in words!
        matches.append(w)
  return matches

def biggest(wordsets):
  result = wordsets[0]
  for alt in wordsets[1:]:
    if len(alt) > len(result):
      result = alt
  return result

def most_common_letters(target, words):
  results = [three_common_letters(w, words, 0, 1, 2),
             three_common_letters(w, words, 0, 1, 3),
             three_common_letters(w, words, 0, 1, 4),
             three_common_letters(w, words, 0, 2, 3),
             three_common_letters(w, words, 0, 2, 4),
             three_common_letters(w, words, 0, 3, 4),
             three_common_letters(w, words, 1, 2, 3),
             three_common_letters(w, words, 1, 2, 4),
             three_common_letters(w, words, 2, 3, 4)
            ]
  return(biggest(results))

words = []
for word in stdin.readlines():
  word = word.rstrip()
  if len(word) != 5:
    print("Error: " + word + " not 5 letters")
  words.append(word)

largest = []
for w in words:
  common = most_common_letters(w, words)
  if len(common) > len(largest):
    largest = common

for w in largest:
  print(w)
