# OP 2023 - Problem 2

# This represents one possible solution, not the only or best solution
# Copyright 2023 - Robert W. Hasker

from sys import stdin
import re

# read words from input document

alltext = re.sub("[\n\r\t]+", ' ', stdin.read())
words = alltext.split()
if len(words[-1]) == 0:
  words = words[:-1]

#print("Words: \'" + "\', \'".join(words) + "\'")
#print("Words: " + str(words))

# find a sequence of words with the same first letter

longest = []
last_letter = '\0'
current = []

for w in words:
  #print("word: `" + w + '"')
  if w[0].lower() == last_letter:
    current.append(w)
  else:
    # if starting a new sequence, see if current sequence the longest
    if len(current) > len(longest):
      longest = current
    last_letter = w[0].lower()
    current = [w]
  # do after checking for word change so we print any previous win
  if w == '$$': 
    print("Longest: " + ' '.join(longest))
    exit(0)
