# OP 2023 - Problem 3
# wrapping paper around tubes

# This represents one possible solution, not the only or best solution
# Copyright 2023 - Robert W. Hasker

from sys import stdin
import math

# calculate amount of wrapping needed for a particular poster
def square_meters_for_poster(poster_size):
  dimensions = poster_size.split('x')
  length = int(dimensions[0])
  width = int(dimensions[1])
  if length > width:
    poster_length = length
    tube_length = width + 2
  else:
    poster_length = width
    tube_length = length + 2
  diameter = 5
  if poster_length > 100:
    if poster_length > 200:
      diameter = 12
    else:
      diameter = 8
  tube_length += 2 * diameter
  wrap_for_tube = tube_length * diameter * math.pi * 1.10
  #print("Poster: {}, length: {}, tube: {}, tube_length: {}, wrap: {:.3f}".
  #      format(poster_size, poster_length, diameter, tube_length, wrap_for_tube))
  return wrap_for_tube / 10000.0 # return value in meters
 
total_wrap = 0.0 # in meters

# read poster sizes, sum wrapper sizes
tube_count = int(stdin.readline().strip())
for i in range(tube_count):
  poster_size = stdin.readline().strip()
  sq_meters = square_meters_for_poster(poster_size)
  #print("Size for " + poster_size + ": " + str(sq_meters))
  total_wrap += sq_meters

print("Order requires {:.2f} square meters of paper".
        format(total_wrap))
