# OP 2023 - Problem 4

# This represents one possible solution, not the only or best solution
# Copyright 2023 - Robert W. Hasker

from sys import stdin
from functools import reduce
import math
import re

SQRT_2 = math.sqrt(2.0)

# calculate main/max for next step
# type: char X int X int -> (float, float) representing north, east
def adjustment(instruction, step_length):
  dir = re.sub('[0-9]*', '', instruction)
  steps = int(re.sub('[^0-9]*', '', instruction))
  dist = float(steps * step_length)
  if dir == 'n':
    return (dist, 0.0);
  elif dir == 'ne':
    return (dist / SQRT_2, dist / SQRT_2)
  elif dir == 'e':
    return (0.0, dist)
  elif dir == 'se':
    return (-dist / SQRT_2, dist / SQRT_2)
  elif dir == 's':
    return (-dist, 0.0)
  elif dir == 'sw':
    return (-dist / SQRT_2, -dist / SQRT_2)
  elif dir == 'w':
    return (0.0, -dist)
  elif dir == 'nw':
    return (dist / SQRT_2, -dist / SQRT_2)
  else:
    print('Illegal direction ' + dir)
    return (0, 0)

# add two pairs of values
def sum_pair(a, b):
  return (a[0] + b[0], a[1] + b[1])
  
# calculate total movement over list of steps
def add_movements(adjustments):
  (north, east) = reduce(sum_pair, adjustments)
  return (north / 100.0, east / 100.0)
  
directions = stdin.readline().lower().split(',')
# remove spaces, trailing X
directions = [x.strip() for x in directions]
#print("DIRECTIONS: " + str(directions))
if directions[-1] != 'x':
  print("ERROR: missing trailing X")
directions = directions[:-1]
min_adjustments = [adjustment(way, 62) for way in directions]
max_adjustments = [adjustment(way, 68) for way in directions]

#print("Minimums: " + str(min_adjustments))
#print("Maximums: " + str(max_adjustments))

(min_north, min_east) = add_movements(min_adjustments)
(max_north, max_east) = add_movements(max_adjustments)

print("Dig in the area from ({:.2f} N, {:.2f} E) to ({:.2f} N, {:.2f} E)".
        format(min_north, min_east, max_north, max_east)
     )
        
