# OP 2023 - Problem 5

# This represents one possible solution, not the only or best solution
# Copyright 2023 - Robert W. Hasker

# leet table: https://simple.wikipedia.org/wiki/Leet

from sys import stdin
import re

# read all words, filting those that are the wrong length
six_letter_words = []
for line in stdin:
  line = line.strip()
  if len(line) == 6:
    six_letter_words.append(line.upper())

matchable_plate_pattern = re.compile('[A-Z]{3}[OILZEMWASGTBXJP]{3}')
matchable = [w for w in six_letter_words
             if matchable_plate_pattern.fullmatch(w)]

letter_to_number = {
  'O': 0,
  'I': 1,
  'L': 1,
  'Z': 2,
  'E': 3,
  'M': 3,
  'W': 3,
  'A': 4,
  'S': 5,
  'G': 6,
  'T': 7,
  'B': 8,
  'X': 8,
  'J': 9,
  'P': 9
  }
  
# apply leet translation to each plate
leet_words = []
for m in matchable:
  base = m[:3]
  digits = [str(letter_to_number[c]) for c in m[3:]]
  leet_words.append(base + ''.join(digits))

# display result in alphanumeric order
leet_words.sort()
for w in leet_words:
  print(w)
