# OP 2023 - Problem 6
# solution to rule184

# This represents one possible solution, not the only or best solution
# Copyright 2023 - Robert W. Hasker

length = int(input("Enter road length: "))
road = input("Initial conditions (.=space, c=car): ").strip()
print()
if len(road) > length:
  print("Road too long")
  exit(1)
road += ('.' * (length - len(road)))
road = [c for c in road] # convert to list
if len([x for x in road if x != '.' and x != 'c']) > 0:
  print("Initial conditions must all be . or c")
  exit(1)
step = 0
while 'c' in road:
  #print("At step {}, road is {}".format(step, ''.join(road)))
  step += 1
  car_flies_away = road[-1] == 'c'
  new_road = road.copy()
  for i in range(length - 1):
    if road[i] == 'c' and road[i + 1] == '.':
      new_road[i] = '.'
      new_road[i + 1] = 'c'
  if car_flies_away:
    new_road[length - 1] = '.'
  road = new_road
print("Time to clear the road: " + str(step) + " ticks")
