# problem 3, OpComp 2024, Milwaukee School of Engineering
# Copyright 2024, Robert W. Hasker

primes = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97]

def find_prime_pairs(years_apart):
    """Find pairs of prime numbers that are 'years_apart' apart and both primes."""
    prime_pairs = []
    for child_age in primes:
        parent_age = child_age + years_apart
        if parent_age in primes:
            prime_pairs.append((child_age, parent_age))
    return prime_pairs

# Prompt for the number of years apart
years_apart = int(input("Enter the difference between the child and parent's ages: "))
prime_pairs = find_prime_pairs(years_apart)

if len(prime_pairs) > 0:
  print(f"A {years_apart} year difference gives {len(prime_pairs)} gifts with the last at {prime_pairs[-1][0]} and {prime_pairs[-1][1]}.")
else:
  print(f"A {years_apart} year difference gives 0 gifts.")
