# problem 5, OpComp 2024, Milwaukee School of Engineering
# Copyright 2024, Robert W. Hasker

import math

# result: map of heights (as integer centimeters)
def read_map(file, rows, columns):
  map = []
  for r in range(rows):
    line = file.readline().strip()
    if len(line) != columns:
        print("BAD DATA: " + line)
    heights = [ord(x) - ord('a') for x in line]
    map += [heights]
  return map

def smallest_distance(max_distance, ceiling, floor, rows, columns):
  closest = max_distance
  for r in range(rows):
    for c in range(columns):
      dist = max_distance - ceiling[r][c] - floor[r][c]
      if dist < closest:
         closest = dist
      #print("Distance at [{}, {}]: {}, closest = {}".format(r, c, dist, closest))
  return closest

fname = input("Enter name of file: ")
file = open(fname, 'r')

max_distance = int(file.readline())
rows = int(file.readline())
columns = int(file.readline())

ceiling = read_map(file, rows, columns)
file.readline() # skip blank line
floor = read_map(file, rows, columns)
dist = smallest_distance(max_distance, ceiling, floor, rows, columns)
#print("closest distance: " + str(dist) + " cm")
years = math.ceil(dist / 0.2 * 10.0)

print("Number of years: " + str(years))
