# problem 6, OpComp 2024, Milwaukee School of Engineering
# Copyright 2024, Robert W. Hasker

from sys import stdin
import math

class Box:
  def __init__(self, id, text_dimension):
    self._original_dimension = text_dimension
    fields = text_dimension.strip().split('x')
    self._name   = id
    self._height = float(fields[0])
    self._width  = float(fields[1])
    self._length = float(fields[2])
  def size(self):
    return self._width * self._height * self._length
  def is_zero(self):
    return self._height == 0 and self._width == 0 and self._length == 0
  def can_hold(self, other):
   return self._height >= other._height + 1 and \
          ((self._width >= other._width + 1 and self._length >= other._length + 1) or \
           (self._width >= other._length + 1 and self._length >= other._width + 1))
  def __str__(self):
    return "{}: {}".format(self._name, self._original_dimension)

boxes = []
for line in stdin.readlines():
  name_and_size = line.strip().split()
  b = Box(name_and_size[0], name_and_size[1])
  if b.is_zero():
    break;
  boxes += [b]

#print("Boxes in order: " + str([str(x) for x in boxes]))

stacks = []
nested = [boxes[0]]
for b in boxes[1:]:
  if nested[-1].can_hold(b):
    nested.append(b)
  else:
    stacks.append(nested)
    nested = [b]
if len(nested) > 0:
  stacks.append(nested)
for s in stacks:
  print(", ".join([str(x) for x in s]))
