package train;

// A tanker for carrying liquid freight in a large cylinder
public class Tanker extends Car {
    private double diameter;

    public double getDiameter() {
        return diameter;
    }

    public void setDiameter(double diameter) {
        this.diameter = diameter;
    }

    public Tanker(double emptyKilograms, double freightKilograms, double maxFreightKilograms,
                  double lengthMeters, String cargoDescription, double diameter) {
        super(emptyKilograms, freightKilograms, maxFreightKilograms, lengthMeters, cargoDescription);
        this.diameter = diameter;
    }

    @Override
    public double getVolumeLiters() {
        return getLengthMeters() * (diameter /2.0) * (diameter / 2.0) * Math.PI;
    }
}
