package train;

import java.util.ArrayList;

// a full train
public class Train {
    private ArrayList<Car> cars;

    public Train() {
        cars = new ArrayList<>();
    }

    public int numCars() {
        return cars.size();
    }

    public void addCarToEnd(Car newCar) {
        cars.add(newCar);
    }

    public Car carAt(int index) {
        return cars.get(index);
    }

    public static void main(String[] args) {
        Train myTrain = new Train();

        // http://www.railforum.com/cgi-bin/ultimatebb.cgi/topic/6/122.html
        //   typical box car: 28,000 weight, 90,000 load limit
        BoxCar box1 = new BoxCar(2.8e4, 4.5e4,
                9e4, 20.0, "appliances",
                1.8e5);
        BoxCar box2 = new BoxCar(2.8e4, 7.5e4,
                9e4, 20.0, "bed frames",
                1.8e5);
        Tanker tanker1 =new Tanker(2.2e4, 7.2e4, 9e4,
                20.0, "distilled water",3.1);
        myTrain.addCarToEnd(box1);
        myTrain.addCarToEnd(box2);
        myTrain.addCarToEnd(tanker1);

        double weightOfTrain = 0.0;
        for (int i = 0; i < myTrain.numCars(); ++i) {
            double carWeight = myTrain.carAt(i).getTotalWeight();
            weightOfTrain += carWeight;
        }
        System.out.printf("Total weight: %.4g kg\n", weightOfTrain);

        double totalVolume = 0.0;
        for (int i = 0; i < myTrain.numCars(); ++i) {
            double carVolume = myTrain.carAt(i).getVolumeLiters();
            totalVolume += carVolume;
        }
        System.out.printf("Total volume: %.4g l\n", totalVolume);
    }
}
