package counter;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.util.Duration;

public class Controller {

    @FXML
    public TextField counter1Field, counter2Field, sumField;
    @FXML
    private Button pauseButton;

    private UpCounter1 up1;
    private UpCounter2 up2;
    private Thread counter1Thread, counter2Thread;
    private boolean paused = false;

    public Controller() {
    }

    public int valueOf(TextField source) {
        int value = -1;
        try {
            value = Integer.parseInt(source.getText());
        } catch (NumberFormatException e) {
            value = 99999;
        }
        return value;
    }

    public boolean countersPaused() {
        return paused;
    }

    public void setTo(TextField target, int value) {
        target.setText(value + "");
    }

    @FXML
    public void startUpCounter1() {
        if (up1 == null) {
            up1 = new UpCounter1(this);
            counter1Thread = new Thread(up1);
            // force shutting down the thread when exit the program - this is not a
            //    clean way to quit threads, but works fine in this case
            counter1Thread.setDaemon(true);
            counter1Thread.start();
        }
    }

    @FXML
    public void startUpCounter2() {
        if (up2 == null) {
            up2 = new UpCounter2(this);
            counter2Thread = new Thread(up2);
            counter2Thread.setDaemon(true);
            counter2Thread.start();
        }
    }

    @FXML
    public void clickPause() {
        paused = !paused;
        pauseButton.setText(paused ? "Resume" : "Pause");
    }
}
