package time;

import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Created by rob on 2/4/18.
 */
public class ClockTest {
    @org.junit.Test
    public void advanceMinute() throws Exception {
        Clock t = new Clock(10, 18);
        t.advance();
        assertEquals("10:19", t.toString());
    }

    @org.junit.Test
    public void advanceMinuteOverMidnight() throws Exception {
        Clock t = new Clock(23, 58);
        t.advance();
        assertEquals("23:59", t.toString());
        t.advance();
        assertEquals("0:00", t.toString());
        t.advance();
        assertEquals("0:01", t.toString());
    }

    @org.junit.Test
    public void advance255Minutes() throws Exception {
        Clock t = new Clock(10, 59);
        for(int i = 0; i < 255; ++i)
            t.advance();
        // 10:59, advance 255 ticks, or 254 minutes past 11:00
        //    works out to 4 hours, 14 minutes later
        assertEquals("15:14", t.toString());
    }

    @org.junit.Test
    public void setWithMoreThan60MinutesNearMidnight() throws Exception {
        Clock t = new Clock(1, 2);
        t.set(22, 130);
        assertEquals("0:10", t.toString());
    }

    @org.junit.Test
    public void totalMinutes() throws Exception {
        Clock t = new Clock(2, 33);
        assertEquals(120 + 33, t.totalMinutes());
    }

    @org.junit.Test
    public void getHours() throws Exception {
        Clock t = new Clock(2, 73);
        assertEquals(3, t.getHours());
    }

    @org.junit.Test
    public void getMinutes() throws Exception {
        Clock t = new Clock(2, 73);
        assertEquals(13, t.getMinutes());
    }

    @org.junit.Test
    public void toString0_0() throws Exception {
        Clock t = new Clock(0, 0);
        assertEquals("0:00", t.toString());
    }

    @org.junit.Test
    public void toString9_8() throws Exception {
        Clock t = new Clock(9, 8);
        assertEquals("9:08", t.toString());
    }

    @org.junit.Test
    public void toString23_1() throws Exception {
        Clock t = new Clock(23, 1);
        assertEquals("23:01", t.toString());
    }

    @org.junit.Test
    public void fromString0_0() throws Exception {
        Clock t = Clock.fromString("24:00");
        assertEquals("0:00", t.toString());
    }

    @org.junit.Test
    public void fromString33_8() throws Exception {
        Clock t = Clock.fromString("33:8");
        assertEquals("9:08", t.toString());
    }

    @org.junit.Test
    public void fromString23_1() throws Exception {
        Clock t = Clock.fromString("23:01");
        assertEquals("23:01", t.toString());
    }

}