//
// Class Time: records time in hours and minutes with operation to advance time
//

package time;

public class Time extends AbstractTime {
    private int hours, minutes;

    /**
     * Create time object given hours and minutes
     * @param hours number of hours
     * @param minutes number of minutes; can be > 60
     */
    public Time(int hours, int minutes) {
        set(hours, minutes);
    }

    /**
     * Advance time by one minute, rolling minutes as necessary
     */
    public void advance() {
        minutes++;
        if (minutes >= MINUTES_PER_HOUR) {
            hours++;
            minutes = 0;
        }
    }

    /**
     * Set time to given hours, minutes
     * @param hours number of hours
     * @param minutes number of minutes; can be > 60
     */
    public void set(int hours, int minutes) {
        this.hours = hours + minutes / MINUTES_PER_HOUR;
        this.minutes = minutes % MINUTES_PER_HOUR;
    }

    /**
     * Returns number of hours represented by the time object.
      * @return hours, with no guarantee that it's between 0 and 23
     */
    public int getHours() {
        return hours;
    }

    /**
     * Returns number of minutes past the hour represented by the time object.
     * @return minutes, 0 <= minutes < 60
     */
    public int getMinutes() {
        return minutes;
    }

    /**
     * Return parsed time object, or returns null if string does not represent a valid time
     * @param input string to be parsed
     * @return corresponding time object or null
     */
    public static Time fromString(String input) {
        String[] parts = input.split(":");
        if (parts.length != 2)
            return null;
        try {
            int hours = Integer.parseInt(parts[0]);
            int minutes = Integer.parseInt(parts[1]);
            return new Time(hours, minutes);
        } catch (NumberFormatException e) {
            return null;
        }
    }
}
