package counter;

import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.Timeline;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.util.Duration;
import javafx.application.Platform;

public class Controller {

  @FXML
  public TextField counterAField, counterBField, computedField, arithSumField;
  @FXML
  private Button pauseButton;

  private UpCounterA upA;
  private UpCounterB upB;
  private Thread counterAThread, counterBThread, arithSumThread;
  private boolean paused = false;

  // the following is used only by valueOf when supporting multi-threading
  private String tempText;

  public Controller() {
  }

  public int valueOf(TextField source) {
    //String tempText = source.getText();
    // better:
    Platform.runLater(() -> {tempText = source.getText();});
    final String toParse = tempText;
    try {
      return Integer.parseInt(toParse);
    } catch (NumberFormatException e) {
      return 99999;
    }
  }

  public boolean countersPaused() {
    return paused;
  }

  public synchronized void incrementSumField() {
    int sum = valueOf(computedField);
    try {
      // simulate time to update this data
      Thread.sleep(1);
    } catch (InterruptedException e) {
      // do nothing
    }
    setTo(computedField, sum + 1);
  }


  public void setTo(TextField target, int value) {
    //target.setText(value + "");
    // better:
    Platform.runLater(() -> {target.setText(value + "");});
  }

  @FXML
  public void startUpCounterA() {
    if (upA == null) {
      upA = new UpCounterA(this);
      counterAThread = new Thread(upA);
      // force shutting down the thread when exit the program - this is not a
      //    clean way to quit threads, but works fine in this case
      counterAThread.setDaemon(true);
      counterAThread.start();
    }
  }

  @FXML
  public void startUpCounterB() {
    if (upB == null) {
      upB = new UpCounterB(this);
      counterBThread = new Thread(upB);
      counterBThread.setDaemon(true);
      counterBThread.start();
    }
  }

  @FXML
  public void clickPause() {
    paused = !paused;
    pauseButton.setText(paused ? "Resume" : "Pause");
    if ( !paused ) 
      arithSumField.setText("");
    else {
      int a = valueOf(counterAField);
      int b = valueOf(counterBField);
      arithSumField.setText(a + b + "");
    }
  }
}
