//
// Main: create form displaying two counters that don't quite add up
//
// This shows the effects of unprotected counters.
// Add `synchronized' to Controller.incrementSumField for a better behavior,
//   but note that it runs slower and there are still GUI errors due to
//   form updates not being thread-safe. To get rid of these errors, use 
//   RunLater in setTo and valueOf:
//      Platform.runLater(() -> (target.setText(value + "")); // setTo
//   and
//      Plateform.runLater(() -> 
//        value = Integer.parseInt(source.getText()));          // valueOf
//

package counter;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class Main extends Application {

  @Override
  public void start(Stage primaryStage) throws Exception {
    Parent root = FXMLLoader.load(getClass().getResource("counter.fxml"));
    primaryStage.setTitle("1 + 1 = 2?");
    primaryStage.setScene(new Scene(root, 400, 275));
    primaryStage.show();
  }

  public static void main(String[] args) {
    launch(args);
  }
}
