//package wk7_command.gui; // MSOE. Dr. Yoder. 02 February 2016.
package gui;

import phonebook.*;

import javax.swing.*;

/**
 * This class manages a modal dialog for entering a new user.
 * <p>
 * A modal dialog is one that blocks the rest of the app until it is completed.
 * It's otherwise known as an annoying pop-up box.
 * More details on Wikipedia.
 */
public class EntryOptionPane {
   private JTextField nameField;
   private JTextField phoneField;
   private final JPanel myPanel;

   public EntryOptionPane() {
      nameField = new JTextField(10);
      phoneField = new JTextField(10);

      myPanel = new JPanel();
      myPanel.add(new JLabel("name:"));
      myPanel.add(nameField);
      myPanel.add(Box.createHorizontalStrut(15)); // a spacer
      myPanel.add(new JLabel("phone number:"));
      myPanel.add(phoneField);
   }

   public String getName() {
      return nameField.getText();
   }

   public String getPhone() {
      return phoneField.getText();
   }

   public int showModalDialog() {
      return showModalDialog(new Entry("", ""));
   }

   /**
    * Shows a blank dialog.
    * Returns result of the JOptionPane.  Value returned by showConfirmDialog
    */
   public int showModalDialog(Entry entry) {
      nameField.setText(entry.name());
      phoneField.setText(entry.phone());
      return JOptionPane.showConfirmDialog(null, myPanel,
            "Please enter the information for the new contact", JOptionPane.OK_CANCEL_OPTION);
   }
}
