//package pbook;

// top level policy operations for use from user interface
// (making it a façade for the phonebook with history)
public class Handler {
  protected History history = new History();
  protected PhoneBook pb = new PhoneBook();

  // add a new phone entry
  public void addEntry(String name, String phone_number) {
    history.doCommand(new AddCommand(pb, new Entry(name, phone_number)));
  }

  // remove an existing entry; does nothing if entry not there
  public void removeEntry(String name) {
    history.doCommand(new RemoveCommand(pb, name));
  }

  // return the history
  public History getHistory() {
    return history;
  }

  // return the phone book
  public PhoneBook getPhoneBook() {
    return pb;
  }

  public void undo() {
    history.undo();
  }

  public void redo() {
    history.redo();
  }
}
