//
// Class Time: records time in hours and minutes with operation to advance time
//

package time;

public abstract class AbstractTime {

    public final int MINUTES_PER_HOUR = 60;

    /**
     * Advance time by one minute, rolling minutes as necessary
     */
    public abstract void advance();

    /**
     * Set time to given hours, minutes
     * @param hours number of hours
     * @param minutes number of minutes; can be > 60
     */
    public abstract void set(int hours, int minutes);

    /**
     * Computes total number of minutes since previous midnight
     * @return integer minutes since midnight
     */
    public int totalMinutes() { return getHours() * MINUTES_PER_HOUR + getMinutes(); }

    /**
     * Returns number of hours represented by the time object.
      * @return hours, with no guarantee that it's between 0 and 23
     */
    public abstract int getHours();

    /**
     * Returns number of minutes past the hour represented by the time object.
     * @return minutes, 0 <= minutes < 60
     */
    public abstract int getMinutes();

    /**
     * Returns string representation of the time object using h:mm format where 0 <= mm < 60
     * @return string in h:mm format with leading 0's suppressed for hours and always 2 digits
     */
    public String toString() {
        if (getMinutes() < 10)
            return getHours() + ":0" + getMinutes();
        else
            return getHours() + ":" + getMinutes();
    }

    /**
     * Factory method returning indicated time object
     * @param hours input hours
     * @param minutes input minutes
     * @param type "time" or "clock" (any case) indicating type of object to create
     * @return
     */
    public static AbstractTime makeTime(int hours, int minutes, String type) {
        if (type.equalsIgnoreCase("time"))
            return new Time(hours, minutes);
        else
            return new Clock(hours, minutes);
    }
}
