package time;

import static org.junit.Assert.*;

/**
 * Tests for class Time
 *
 * NOTE: no named constants to keep the tests easily maintained and clear.
 */
public class TimeTest {
    @org.junit.Test
    public void advanceMinute() throws Exception {
        Time t = new Time(10, 18);
        t.advance();
        assertEquals("10:19", t.toString());
    }

    @org.junit.Test
    public void advanceHour() throws Exception {
        Time t = new Time(10, 59);
        t.advance();
        assertEquals("11:00", t.toString());
    }

    @org.junit.Test
    public void advance255Minutes() throws Exception {
        Time t = new Time(10, 59);
        for(int i = 0; i < 255; ++i)
            t.advance();
        // 10:59, advance 255 ticks, or 254 minutes past 11:00
        //    works out to 4 hours, 14 minutes later
        assertEquals("15:14", t.toString());
    }

    @org.junit.Test
    public void setWithMoreThan60Minutes() throws Exception {
        Time t = new Time(1, 2);
        t.set(5, 130);
        assertEquals("7:10", t.toString());
    }

    @org.junit.Test
    public void totalMinutes() throws Exception {
        Time t = new Time(2, 33);
        assertEquals(120 + 33, t.totalMinutes());
    }

    @org.junit.Test
    public void getHours() throws Exception {
        Time t = new Time(2, 73);
        assertEquals(3, t.getHours());
    }

    @org.junit.Test
    public void getMinutes() throws Exception {
        Time t = new Time(2, 73);
        assertEquals(13, t.getMinutes());
    }

    @org.junit.Test
    public void toString0_0() throws Exception {
        Time t = new Time(0, 0);
        assertEquals("0:00", t.toString());
    }

    @org.junit.Test
    public void toString9_8() throws Exception {
        Time t = new Time(9, 8);
        assertEquals("9:08", t.toString());
    }

    @org.junit.Test
    public void toString23_1() throws Exception {
        Time t = new Time(23, 1);
        assertEquals("23:01", t.toString());
    }

    @org.junit.Test
    public void fromString0_0() throws Exception {
        Time t = Time.fromString("00:00");
        assertEquals("0:00", t.toString());
    }

    @org.junit.Test
    public void fromString9_8() throws Exception {
        Time t = Time.fromString("9:8");
        assertEquals("9:08", t.toString());
    }

    @org.junit.Test
    public void fromString23_1() throws Exception {
        Time t = Time.fromString("23:01");
        assertEquals("23:01", t.toString());
    }

}