//
// tasklist.cpp: TaskList implementation
//

#include "tasklist.h"
#include "task.h"

TaskList::TaskList() : count{0}
{ }

void TaskList::add(Task *new_task)
{
  if ( count >= MAX_TASKS )
    throw "Task list full.";
  todo[count] = new_task;
  ++count;
}

bool TaskList::empty()
{
  return count == 0;
}

bool TaskList::full()
{
  return count >= MAX_TASKS;
}

double TaskList::totalHours()
{
  auto tot = 0.0;
  for(int i = 0; i < count; ++i)
    tot += todo[i]->hours();
  return tot;
}
