//
// tasklist.h: TaskList interface
//

#ifndef _tasklist_h
#define _tasklist_h

#include "task.h"               // necessary?

// A collection of tasks with operations to add tasks and compute
//    the total time across all tasks.
class TaskList
{
private:
  static constexpr int MAX_TASKS = 50;
  long   count; // before array to simplify viewing the count
  Task  *todo[MAX_TASKS];
public:
  TaskList();
  // Add new_task to the end of the todo list.
  //   PRE: list is not full
  void add(Task *new_task);
  // Return true iff todo list has no items
  bool empty();
  // Return true iff todo list cannot include any more items
  bool full();
  // Computes the total hours across all tasks
  double totalHours();
};

#endif
