package bee_simulator;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class Main extends Application {

  private GardenController bee_simulator;

  @Override
  public void start(Stage primaryStage) throws Exception {
    FXMLLoader loader = new FXMLLoader(getClass().getResource("bee_simulator.fxml"));
    Parent root = loader.load();
    primaryStage.setTitle("Bee Runner 2049");
    primaryStage.setScene(new Scene(root));
    primaryStage.show();
    bee_simulator = loader.getController();
  }

  @Override
  public void stop() throws Exception {
    super.stop();
    if ( bee_simulator != null ) {
      // without this, the timer keeps running after the GUI thread halts, so the
      //    application keeps running
      bee_simulator.randomBeeMovementTimer.cancel();
    }
  }

  public Main() {
  }

  public static void main(String[] args) {
    launch(args);
  }
}
