//
// Main: create form displaying two counters that don't quite add up
//
// This shows the effects of unprotected counters.
// Add **synchronized** to Controller.incrementSumField for a better behavior,
//   but note that it runs slower and there are still GUI errors due to
//   form updates not being thread-safe. To get rid of these errors, use 
//   RunLater in setTo and valueOf:
//      Platform.runLater(() -> (target.setText(value + "")); // setTo
//   and
//      Platform.runLater(() ->
//        value = Integer.parseInt(source.getText()));          // valueOf
//

package counter;

import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

import java.util.MissingResourceException;

public class Main extends Application {

  public static void main(String[] args) {
    launch(args);
  }

  @Override
  public void start(Stage primaryStage) throws Exception {
    var root_resource = getClass().getResource("counter.fxml");
    if ( root_resource == null )
      throw new MissingResourceException("Cannot open .fxml file",
                                         getClass().getName(), "");
    Parent root = FXMLLoader.load(root_resource);
    primaryStage.setTitle("1 + 1 = 2?");
    var primaryScene = new Scene(root, 500, 275);
    // not working: primaryScene.getStylesheets().add("counter.css");
    primaryStage.setScene(primaryScene);
    primaryStage.show();
  }
}
