package counter;

public class UpCounterA implements Runnable {
  private final int COMPUTE_TIME = 100;
  private Controller counterController;
  private int currentCount = 0;

  public UpCounterA(Controller c) {
    counterController = c;
  }

  public int getCount() { return currentCount; }

  public void run() {
    while (true) {
      counterController.doWorkFor(COMPUTE_TIME);       // simulate doing work to compute some result
      counterController.checkPaused();
      ++currentCount;
      counterController.setTo(counterController.counterAField, currentCount);
      // uncomment following to ensure sum is consistent
     // synchronized (counterController.sum_update_lock)
      {
        int sum = counterController.getCounterSum();
        // simulate computing sum in a complex way
        counterController.doWorkFor(Controller.COMPUTE_SUM_TIME);
        counterController.setCounterSum(sum + 1);
      }
      counterController.setTo(counterController.computedSumField, counterController.getCounterSum());
    }
  }
}
