package counter;

public class UpCounterB implements Runnable {
  private final int COMPUTE_TIME = 75;
  private Controller counterController;
  private int currentCount = 0;

  public UpCounterB(Controller c) {
    counterController = c;
  }

  public int getCount() { return currentCount; }

  public void run() {
    while (true) {
      counterController.doWorkFor(COMPUTE_TIME);       // simulate doing work to compute some result; different than A
      counterController.checkPaused();
      ++currentCount;
      counterController.setTo(counterController.counterBField, currentCount);
      // uncomment following to ensure sum is consistent
      // synchronized (counterController.sum_update_lock)
      {
        int sum = counterController.getCounterSum();
        // simulate computing sum in a complex way
        counterController.doWorkFor(Controller.COMPUTE_SUM_TIME);
        counterController.setCounterSum(sum + 1);
      }
      counterController.setTo(counterController.computedSumField, counterController.getCounterSum());
    }
  }
}
