package weather_sensors;

import observer.Observer;
import observer.Subject;
import java.util.Collection;
import java.util.LinkedList;

// This class defines the standard behaviors of an observable Weather Data Sensor
public abstract class WeatherSensor implements Subject {

   /**
    * @return the temp
    */
   abstract double currentTemperature();

   /**
    * @return the wind speed
    */
   abstract double currentWindSpeed();

   // Implementing the Observer Pattern

   protected Collection<Observer> observers = new LinkedList<Observer>();

   @Override
   public void attach(Observer o) {
      observers.add(o);
   }

   @Override
   public void detach(Observer o) {
      observers.remove(o);
   }

   @Override
   public void notifyObservers() {
      for (Observer o : observers) {
         o.update();
      }
   }

   @Override
   public boolean hasObserver(Observer o) {
      return observers.contains(o);
   }
}
