package weather_sensors;

import observer.Observer;

public class WeatherSensorSimulator extends WeatherSensor {
   private double temp;
   private double windSpeed;
   private volatile boolean running = true;

   public WeatherSensorSimulator() {
      startSimulation();
   }

   @Override
   public double currentTemperature() {
      return temp;
   }

   @Override
   public double currentWindSpeed() {
      return windSpeed;
   }

   private void startSimulation() {
      new Thread(() -> acquireDataFromSensors()).start();
   }

   private void acquireDataFromSensors() {
      while (running) {
         try {
            Thread.sleep(1000);
         } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
         }
         temp = 74.0 + Math.random();
         windSpeed = 4.8 + Math.random() * 0.4;
         System.out.printf("T: %4.1f, S: %4.1f\n", temp, windSpeed);
         notifyObservers();
      }
   }

   public void stopSimulation() {
      running = false;
      System.out.println("Weather simulation stopped.");
   }

   @Override
   public void attach(Observer o) {
      super.attach(o);
      System.out.println("Attached observer " + o.getClass().getCanonicalName() + " to " +
        this.getClass().getName());
   }

   @Override
   public void detach(Observer o) {
      super.detach(o);
      System.out.println("Detached observer " + o.getClass().getCanonicalName() + " from " +
        this.getClass().getCanonicalName());
   }
}
