// WeatherStationApp
//   Original author: Jay Urbain
//   Modified by: Josiah Yoder, Rob Hasker
//   Converted to JavaFX: A. Pranay, fall 2024
// Copyright Milwauke School of Engineering, 2024

package weather_station;

import javafx.application.Application;
import javafx.stage.Stage;
import weather_sensors.WeatherSensorSimulator;

public class Main extends Application {

   private WeatherSensorSimulator weatherSensorSimulator;

   @Override
   public void start(Stage primaryStage) {

      weatherSensorSimulator = new WeatherSensorSimulator();
      new WeatherStationMainDisplay(weatherSensorSimulator);
      new TemperatureDisplay(weatherSensorSimulator);
   }

   @Override
   public void stop() {
      weatherSensorSimulator.stopSimulation();
      System.out.println("JavaFX application stopped.");
   }

   public static void main(String[] args) {
      launch(args);
   }
}
