package weather_station;

import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import observer.Observer;
import weather_sensors.WeatherSensorSimulator;

import java.text.DecimalFormat;

public class WeatherStationMainDisplay extends Stage implements Observer {

   private final WeatherSensorSimulator wdg;
   private final Label txtTemperature;
   private final Label txtWindSpeed;

   public WeatherStationMainDisplay(WeatherSensorSimulator wdg) {
      this.wdg = wdg;
      this.txtTemperature = new Label();
      this.txtWindSpeed = new Label();

      wdg.attach(this);
      wdg.notifyObservers();

      setupUI();
   }

   @Override
   public void update() {
      Platform.runLater(this::updateDisplay);
   }

   private void updateDisplay() {
      DecimalFormat df = new DecimalFormat("0.0");
      txtTemperature.setText("Temperature: " + df.format(wdg.currentTemperature()) + " F");
      txtWindSpeed.setText("Wind Speed: " + df.format(wdg.currentWindSpeed()) + " MPH");
   }

   private void setupUI() {
      VBox root = new VBox(10);
      root.setStyle("-fx-background-color: black; -fx-padding: 10; -fx-alignment: center;");

      txtTemperature.setStyle("-fx-font-size: 24; -fx-text-fill: white;");
      txtWindSpeed.setStyle("-fx-font-size: 24; -fx-text-fill: white;");

      Button toggleUpdates = new Button("Toggle Updates");
      toggleUpdates.setOnAction(e -> {
         if (wdg.hasObserver(this)) {
            wdg.detach(this);
         } else {
            wdg.attach(this);
         }
      });

      Button quitButton = new Button("Quit");
      quitButton.setOnAction(e -> Platform.exit());

      root.getChildren().addAll(txtTemperature, txtWindSpeed, toggleUpdates, quitButton);

      this.setTitle("Weather Station Main Display");
      this.setScene(new Scene(root, 400, 300));
      this.show();
   }
}
