package weather_station;

import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import observer.Observer;
import weather_sensors.WeatherSensorSimulator;

import java.text.DecimalFormat;

public class TemperatureDisplay extends Stage implements Observer {

   private final WeatherSensorSimulator wdg;
   private final Label txtTemperature;
   private boolean isSubscribed;

   public TemperatureDisplay(WeatherSensorSimulator wdg) {
      this.wdg = wdg;
      this.txtTemperature = new Label();
      this.isSubscribed = true;

      wdg.attach(this);
      wdg.notifyObservers();

      setupUI();
   }

   @Override
   public void update() {
      Platform.runLater(this::updateDisplay);
   }

   private void updateDisplay() {
      double temp = wdg.currentTemperature();
      DecimalFormat df = new DecimalFormat("0.0");
      txtTemperature.setText(df.format(temp) + " F");
   }

   private void setupUI() {
      VBox root = new VBox(10);
      root.setStyle("-fx-background-color: blue; -fx-padding: 10; -fx-alignment: center;");

      txtTemperature.setStyle("-fx-font-size: 48; -fx-text-fill: white;");

      Button toggleUpdates = new Button("Toggle Temp Updates");
      toggleUpdates.setOnAction(e -> {
         if (isSubscribed) {
            wdg.detach(this);
            isSubscribed = false;
            toggleUpdates.setText("Resume Temp Updates");
         } else {
            wdg.attach(this);
            isSubscribed = true;
            toggleUpdates.setText("Toggle Temp Updates");
         }
      });

      root.getChildren().addAll(txtTemperature, toggleUpdates);

      this.setTitle("Temperature Display");
      this.setScene(new Scene(root, 300, 200));
      this.show();
   }
}
